/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.config.world;

import dev.toma.configuration.config.Configurable;
import net.minecraft.world.biome.Biome;

public class DimensionalMobSpawnConfig {
    @Configurable
    @Configurable.Range(min=0L, max=96L)
    @Configurable.Comment(value={"Overworld spawn chance"})
    public int overworld;
    @Configurable
    @Configurable.Range(min=0L, max=96L)
    @Configurable.Comment(value={"Nether spawn chance"})
    public int nether;
    @Configurable
    @Configurable.Range(min=0L, max=96L)
    @Configurable.Comment(value={"End spawn chance"})
    public int end;

    public DimensionalMobSpawnConfig(int overworld, int nether, int end) {
        this.overworld = overworld;
        this.nether = nether;
        this.end = end;
    }

    public int overworldChance() {
        return this.overworld;
    }

    public int netherChance() {
        return this.nether;
    }

    public int endChance() {
        return this.end;
    }

    public int choiceFromBiomeCategory(Biome.Category cat) {
        return cat == Biome.Category.NETHER ? this.netherChance() : (cat == Biome.Category.THEEND ? this.endChance() : this.overworldChance());
    }
}

